<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class IranianPhone implements Rule
{

    public $normalizedMobile;


    public function passes($attribute, $value)
    {
        $mobile = preg_replace('/[^0-9]/', '', $value);
        
        
        if (str_starts_with($mobile, '9') && strlen($mobile) === 10) {
            $mobile = '0' . $mobile;
        }
        
        
        $this->normalizedMobile = $mobile;
        
        return strlen($mobile) === 11 && str_starts_with($mobile, '09');
    }


    public function message()
    {
        return 'شماره موبایل باید با 09 شروع شود و 11 رقمی باشد';
    }
}
