@extends('layouts.index')
@section('css-part')
<link rel="stylesheet" href="{{ asset('assets/css/general.panel.css') }}">
<link rel="stylesheet" href="{{ asset('assets/css/jalalidatepicker.min.css') }}">
<style>
    .step-table {
        border: 1px solid #000000;
        width: 100%;
    }

    .step-table th {
        padding: 5px 8px;
        background-color: #5560ad;
        border: 1px solid #000000;
        color: #ffffff;
        text-align: center;
    }

    .step-table td {
        padding: 5px 8px;
        border: 1px solid #000000;
        text-align: center;
    }
</style>
@endsection
@section('js-part')
<script src="{{ asset('assets/js/jalalidatepicker.min.js') }}"></script>
<script src="{{ asset('assets/js/general.panel.js') }}"></script>
<script src="{{ asset('assets/js/works.admin.js') }}"></script>
<script>
    $(document).ready(function() {
        jalaliDatepicker.startWatch({
            minDate: "attr",
            maxDate: "attr",
            minTime: "attr",
            maxTime: "attr",
            time: true,
            date: true,
            hasSecond: true,
            hideAfterChange: false,
            autoHide: true,
            showTodayBtn: true,
            showEmptyBtn: true,
            topSpace: 10,
            bottomSpace: 30,
            overflowSpace: -10,
            dayRendering(opt, input) {
                return {
                    isHollyDay: opt.day == 1,
                };
            },
        });
    });
</script>
@endsection
@section('panel')
@include('layouts.header.header')
@include('layouts.nav.nav')
@endsection
@section('container')
<div class="container">
    @include('layouts.notification.success')
    @include('layouts.notification.error')

    <h2 class=" text-center mt-3">پنل مدیریت</h2>
    <form action="" method="get">
        <div class="row">
            <div class="col-12 col-md-4 col-lg-3 mt-3">
                <label for="reqId" class="mb-2">کد سفارش</label>
                <input type="text" class=" form-control" name="reqId" id="reqId" value="{{request('reqId')}}">
            </div>
            <div class="col-12 col-md-4 col-lg-3  mt-3">
                <label for="step" class="mb-2">وضعیت سفارش</label>
                <select name="step" id="step" class="form-control">
                    <option value="0" {{request('step') == 0 ? 'selected' : ''}} >انتخاب وضعیت</option>
                    <option value="1" {{request('step') == 1 ? 'selected' : ''}}>درخواست جدید</option>
                    <option value="2" {{request('step') == 2 ? 'selected' : ''}}>در انتظار تایید قرارداد</option>
                    <option value="3" {{request('step') == 3 ? 'selected' : ''}}>تایید قرارداد</option>
                    <option value="4" {{request('step') == 4 ? 'selected' : ''}}>در انتظار تحویل</option>
                    <option value="5" {{request('step') == 5 ? 'selected' : ''}}>تایید تحویل راننده</option>
                    <option value="6" {{request('step') == 6 ? 'selected' : ''}}>تایید دریافت مرکز فراوری</option>
                    <option value="7" {{request('step') == 7 ? 'selected' : ''}}>تایید دریافت کلاله توسط سرتیم</option>
                    <option value="8" {{request('step') == 8 ? 'selected' : ''}}>تایید اتمام توسط کارگر</option>
                    <option value="9" {{request('step') == 9 ? 'selected' : ''}}>تایید توسط سرتیم و ارسال به واحد خشک کن</option>
                    <option value="10" {{request('step') == 10 ? 'selected' : ''}}>دریافت توسط خشک کن</option>
                    <option value="11" {{request('step') == 11 ? 'selected' : ''}}>اتمام خشک کردن</option>
                    <option value="12" {{request('step') == 12 ? 'selected' : ''}}>تایید دریافت توسط واحد بسته بندی</option>
                    <option value="13" {{request('step') == 13 ? 'selected' : ''}}>اتمام بسته بندی</option>
                    <option value="-1" {{request('step') == -1 ? 'selected' : ''}}>مغایرت دار</option>
                    <option value="-100" {{request('step') == -100 ? 'selected' : ''}}>لغو شده</option>
                </select>
            </div>
            <div class="col-12 col-md-4 col-lg-3  mt-3">
                <label for="farmer_first_name" class="mb-2">نام کشاورز</label>
                <input type="text" class="form-control" name="farmer_first_name" id="farmer_first_name" value="{{request('farmer_first_name')}}">
            </div>
            <div class="col-12 col-md-4 col-lg-3 mt-3">
                <label for="farmer_last_name" class="mb-2">نام خانوادگی کشاورز</label>
                <input type="text" class="form-control" name="farmer_last_name" id="farmer_last_name" value="{{request('farmer_last_name')}}">
            </div>
            <div class="col-12 col-md-4 col-lg-3 mt-3">
                <label for="phone" class="mb-2">شماره موبایل</label>
                <input type="text" class=" form-control" name="phone" id="phone" value="{{request('phone')}}">
            </div>
            <div class="col-12 col-md-4 col-lg-3 mt-3">
                <label for="farm_name" class="mb-2">نام مزرعه</label>
                <input type="text" class=" form-control" name="farm_name" id="farm_name" value="{{request('farm_name')}}">
            </div>
            <div class="col-12 col-md-4 col-lg-3 mt-3">
                <label for="melli_code" class="mb-2">کد ملی</label>
                <input type="text" class=" form-control" name="melli_code" id="melli_code" value="{{request('melli_code')}}">
            </div>
            <div class="col-12 col-md-4 col-lg-3 mt-3">
                <label for="from" class="mb-2">از تاریخ</label>
                <input type="text" class=" form-control" name="from" id="from" data-jdp value="{{request('from')}}">
            </div>
            <div class="col-12 col-md-4 col-lg-3 mt-3">
                <label for="to" class="mb-2">به تاریخ</label>
                <input type="text" class=" form-control" name="to" id="to" data-jdp value="{{request('to')}}">
            </div>
            <div class="col-12 col-md-4 col-lg-3 mt-3">
                <label for="dateInterval" class="mb-2">بازه زمانی</label>
                <select class=" form-control" name="dateInterval" id="dateInterval">
                    <option value="0">انتخاب بازه زمانی</option>
                    <option value="6" {{request('dateInterval') == 6 ? 'selected' : ''}}>1 روزه</option>
                    <option value="1" {{request('dateInterval') == 1 ? 'selected' : ''}}>1 هفته</option>
                    <option value="2" {{request('dateInterval') == 2 ? 'selected' : ''}}>1 ماهه</option>
                    <option value="3" {{request('dateInterval') == 3 ? 'selected' : ''}}>3 ماهه</option>
                    <option value="4" {{request('dateInterval') == 4 ? 'selected' : ''}}>6 ماهه</option>
                    <option value="5" {{request('dateInterval') == 5 ? 'selected' : ''}}>یکساله</option>
                </select>
            </div>
            <div class="col-12 col-md-4 col-lg-3 mt-3 d-flex align-items-end">
                <button type="submit" class="btn btn-primary">فیلتر</button>
            </div>
            @if(request('reqId') || request('step') || request('farmer_first_name') || request('farmer_last_name') || request('phone') || request('farm_name') || request('melli_code') || request('from') || request('to'))
            <div class="col-12 col-md-4 col-lg-3 mt-3 d-flex align-items-end">
                <a href="{{ request()->url() }}" class="btn btn-outline-secondary">حذف فیلتر</a>
            </div>
            @endif

        </div>
    </form>
    <form action="{{route('admin.printlist')}}" method="get">
        <input type="hidden" name="reqId" value="{{request('reqId')}}">
        <input type="hidden" name="step" value="{{request('step')}}">
        <input type="hidden" name="farmer_first_name" value="{{request('farmer_first_name')}}">
        <input type="hidden" name="farmer_last_name" value="{{request('farmer_last_name')}}">
        <input type="hidden" name="farm_name" value="{{request('farm_name')}}">
        <input type="hidden" name="melli_code" value="{{request('melli_code')}}">
        <input type="hidden" name="from" value="{{request('from')}}">
        <input type="hidden" name="to" value="{{request('to')}}">
        <input type="hidden" name="dateInterval" value="{{request('dateInterval')}}">
        <button type="submit" class="btn btn-outline-light">دریافت خروجی</button>
    </form>
    @include('Admin.list.stat')
    @include('Admin.list.requests')
</div>
@endsection