<form action="{{route('admin.post.edit.user')}}" method="post" class="mb-5">
    {{csrf_field()}}
    <input type="hidden" name="userid" value="{{$UserInfo->id}}">
    <div class="row mt-3">
        <div class="col-12 col-lg-6">
            <div class="form-group">
                <label for="first_name" class="mb-2">نام</label>
                <input type="text" class=" form-control" name="first_name" id="first_name" placeholder="نام" value=" {{$UserInfo->first_name}}">
            </div>
        </div>
        <div class="col-12 col-lg-6 mt-3 mt-lg-0">
            <div class="form-group">
                <label for="last_name" class="mb-2">نام خانوادگی</label>
                <input type="text" class=" form-control" name="last_name" id="last_name" placeholder="نام خانوادگی" value=" {{$UserInfo->last_name}}">
            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-12 col-lg-6">
            <div class="form-group">
                <label for="melli_code" class="mb-2">کد ملی</label>
                <input type="text" class=" form-control" name="melli_code" id="melli_code" placeholder="کد ملی" value=" {{$UserInfo->melli_code}}">
            </div>
        </div>
        <div class="col-12 col-lg-6 mt-3 mt-lg-0">
            <div class="form-group">
                <label for="phone" class="mb-2">شماره موبایل</label>
                <input type="text" class=" form-control" name="phone" id="phone" placeholder="شماره موبایل" value=" {{$UserInfo->phone}}">
            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-12 col-lg-6">
            <div class="form-group">
                <label for="username" class="mb-2">نام کاربری</label>
                <input type="text" class=" form-control" name="username" id="username" placeholder="نام کاربری" value=" {{$UserInfo->username}}">
            </div>
        </div>
        <div class="col-12 col-lg-6 mt-3 mt-lg-0">
            <div class="form-group">
                <label for="password" class="mb-2">رمز عبور</label>
                <input type="text" class=" form-control" name="password" id="password" placeholder="رمز عبور">
            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-12 col-lg-6">
            <div class="form-group">
                <label for="role" class="mb-2">نقش کاربر</label>
                <select name="role" id="role" class="form-control">
                    <option value="0">انتخاب نقش</option>
                    <option value="transporter" {{$UserInfo->role == 'transporter' ? 'selected' : ""}}>راننده</option>
                    <option value="factory_receiver" {{$UserInfo->role == 'factory_receiver' ? 'selected' : ""}}>مرکز فراوری</option>
                    <option value="contractor" {{$UserInfo->role == 'contractor' ? 'selected' : ""}}>امور قرارداد</option>
                    <option value="chief_worker" {{$UserInfo->role == 'chief_worker' ? 'selected' : ""}}>سرتیم</option>
                    <option value="worker" {{$UserInfo->role == 'worker' ? 'selected' : ""}}>کارگر</option>
                    <option value="dryer" {{$UserInfo->role == 'dryer' ? 'selected' : ""}}>خشک کن</option>
                    <option value="packager" {{$UserInfo->role == 'packager' ? 'selected' : ""}}>بسته بندی</option>
                    <option value="distributor" {{$UserInfo->role == 'distributor' ? 'selected' : ""}}>توزیع کننده</option>
                </select>
            </div>
        </div>
        @if ($UserInfo->role == 'worker')
        <div class="col-12 col-lg-6" id="chiefDiv" style="display: block;">
        @else
        <div class="col-12 col-lg-6" id="chiefDiv" style="display: none;">
        @endif
            <div class="form-group">
                <label for="chief" class="mb-2">انتخاب سرتیم</label>
                <select name="chief" id="chief" class="form-control">
                    <option value="0">انتخاب سرتیم</option>
                    @foreach ($chiefWorkers as $chief)
                    <option value="{{$chief->id}}" {{(isset($selectedchiefWorker->user_id) && $selectedchiefWorker->user_id == $chief->id) ? 'selected' : ''}}>{{$chief->first_name}} {{$chief->last_name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>
    <div class="mt-3 d-flex justify-content-between">
        <span class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#removeModal">حذف کاربر</span>
        <button type="submit" class=" btn btn-success">ویرایش کاربر</button>
    </div>
</form>

<div class="modal fade" id="removeModal" tabindex="-1" aria-labelledby="removeModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="removeModalLabel">حذف کاربر</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p class="text-danger text-center">آیا مطمئن هستید که کاربر حذف شود؟</p>
                <form action="{{route('admin.post.delete.user')}}" method="post">
                    {{csrf_field()}}
                    <input type="hidden" name="userId" value="{{$UserInfo->id}}">
                    <div class="d-flex justify-content-center">
                        <button type="submit" class="btn btn-danger" id="CancelOrderBtn">حذف کاربر</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>