<div class="zar-table mt-3">
    <strong class="mb-2">اطلاعات کارکنان:</strong>
    <table>
        <thead>
            <tr>
                <th>ردیف</th>
                <th>نقش</th>
                <th>نام کارمند</th>
                <th>وزن</th>
            </tr>
        </thead>
        <tbody>
            @if ($UserRequests->isNotEmpty())
            @foreach ($UserRequests as $Info)
            <tr>
                <td data-label="ردیف">{{ $loop->iteration }}</td>
                <td data-label="نقش">
                    @switch($Info->role)
                    @case('transporter')
                    راننده
                    @break
                    @case('chief_worker')
                    سرتیم
                    @break
                    @case('worker')
                    کارگر
                    @break
                    @endswitch
                </td>
                <td data-label="نام کارمند">{{ $Info->first_name }} {{ $Info->last_name }}</td>
                <td data-label="وزن">
                    @if ($Info->info != null)
                    {{$Info->info['weight']}}
                    @else
                    -
                    @endif
                </td>
            </tr>
            @endforeach
            @else
            <tr>
                <td colspan="8" class="noinfotable">کارمندی یافت نشد</td>
            </tr>
            @endif

        </tbody>
    </table>
</div>


