<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Farmer;
use App\Http\Controllers\Contractor;
use App\Http\Controllers\General;
use App\Http\Controllers\Transporter;
use App\Http\Controllers\Reciever;
use App\Http\Controllers\ChiefWorker;
use App\Http\Controllers\Worker;
use App\Http\Controllers\Dryer;
use App\Http\Controllers\Pack;
use App\Http\Controllers\Admin;
use App\Http\Controllers\Distributor;



Route::get('/',[General\UserController::class, 'panel'])->name('farmer.panel');
Route::get('/logout',[General\UserController::class, 'logout'])->name('logout');
Route::get('/c/{code}',[General\UserController::class, 'contract'])->name('farmer.contract');
Route::post('/c/send',[Contractor\SignController::class, 'sendsms'])->name('contract.sendsms');
Route::post('/c/validate',[Contractor\SignController::class, 'validateSms'])->name('contract.validate');

Route::middleware('guest')->group(function () {
    Route::get('/login',[Farmer\UserController::class, 'show'])->name('login')->middleware('guest');
    Route::post('/signin',[General\UserController::class, 'login'])->name('general.signin');
    Route::post('/newpassword',[General\UserController::class, 'newpass'])->name('general.newpass');
    Route::post('/register',[Farmer\UserController::class, 'register'])->name('farmer.register');
    Route::post('/sendsms',[Farmer\UserController::class, 'sendsms'])->name('farmer.sendsms');
    Route::post('/checksms',[Farmer\UserController::class, 'checksms'])->name('farmer.checksms');
});

Route::middleware(['auth','role:farmer'])->group(function () {
    Route::get('/order',[Farmer\RequestController::class, 'order'])->name('farmer.panel.order');
    Route::post('/order',[Farmer\RequestController::class, 'AddRequest'])->name('farmer.post.request');
    Route::get('/account',[Farmer\ProfileController::class, 'show'])->name('farmer.profile');
    Route::post('/account',[Farmer\ProfileController::class, 'edit'])->name('farmer.post.profile');
    Route::post('/account/changepassword',[Farmer\ProfileController::class, 'password'])->name('farmer.post.password');
});

Route::middleware(['auth','role:admin'])->prefix('admin')->group(function () {
    Route::get('/',[Admin\UserController::class, 'show'])->name('admin.panel');
    Route::get('/view/{id?}',[Admin\UserController::class, 'view'])->name('admin.view');
    Route::get('/works',[Admin\UserController::class, 'works'])->name('admin.works');
    Route::post('/cancel',[Admin\UserController::class, 'cancel'])->name('admin.post.cancel');
    Route::post('/delete',[Admin\UserController::class, 'delete'])->name('admin.post.delete');
    Route::post('/remove',[Admin\UserController::class, 'remove'])->name('admin.post.remove');
    Route::post('/stepchange',[Admin\UserController::class, 'stepchange'])->name('admin.post.step.change');
    Route::get('/print',[Admin\UserController::class, 'printlist'])->name('admin.printlist');

    // User
    Route::get('/user',[Admin\WorkerController::class, 'show'])->name('admin.user');
    Route::get('/user/view/{id?}',[Admin\WorkerController::class, 'view'])->name('admin.user.view');
    Route::post('/user/add',[Admin\WorkerController::class, 'add'])->name('admin.post.add.user');
    Route::post('/user/edit',[Admin\WorkerController::class, 'edit'])->name('admin.post.edit.user');
    Route::post('/user/delete',[Admin\WorkerController::class, 'delete'])->name('admin.post.delete.user');

    //Profile
    Route::get('/account',[Admin\ProfileController::class, 'show'])->name('admin.profile');
    Route::post('/changepassword',[Admin\ProfileController::class, 'password'])->name('admin.post.password');
    Route::post('/changeprofile',[Admin\ProfileController::class, 'profile'])->name('admin.post.profile');

    //setting 
    Route::get('/setting',[Admin\ProfileController::class, 'setting'])->name('admin.setting');
    Route::post('/set/contract',[Admin\ProfileController::class, 'contract'])->name('admin.post.contract');
    Route::post('/set/salary',[Admin\ProfileController::class, 'salary'])->name('admin.post.salary');
});

Route::middleware(['auth','role:contractor'])->prefix('contractor')->group(function () {
    Route::get('/',[General\UserController::class, 'contractor'])->name('contractor.panel');
    Route::get('/edit/{id?}',[Contractor\UserController::class, 'viewEdit'])->name('contractor.edit');
    Route::post('/cancel',[Contractor\UserController::class, 'cancel'])->name('contractor.post.cancel');
    Route::post('/accept',[Contractor\UserController::class, 'accept'])->name('contractor.post.accept');
    Route::post('/edit',[Contractor\UserController::class, 'edit'])->name('contractor.post.edit');
    Route::get('/account',[Contractor\ProfileController::class, 'show'])->name('contractor.profile');
    Route::post('/changepassword',[Contractor\ProfileController::class, 'password'])->name('contractor.post.password');

    Route::get('/disagreement',[Contractor\DisagreeController::class, 'show'])->name('contractor.disagreement');
    Route::get('/cancel',[Contractor\DisagreeController::class, 'showCancel'])->name('contractor.cancel');
}); 

Route::middleware(['auth','role:transporter'])->prefix('transporter')->group(function () {
    Route::get('/',[General\UserController::class, 'transporter'])->name('transporter.panel');
    Route::get('/delivery/{id?}',[Transporter\UserController::class, 'delivery'])->name('transporter.delivery');
    Route::post('/delivery/accept',[Transporter\UserController::class, 'accept'])->name('transporter.post.accept');
    Route::get('/account',[Transporter\ProfileController::class, 'show'])->name('transporter.profile');
    Route::post('/changepassword',[Transporter\ProfileController::class, 'password'])->name('transporter.post.password');
});

Route::middleware(['auth','role:factory_receiver'])->prefix('receiver')->group(function () {
    //Primary
    Route::get('/',[Reciever\UserController::class, 'show'])->name('factory.reciever.panel');
    Route::get('/edit/{id?}',[Reciever\UserController::class, 'viewEdit'])->name('factory.reciever.edit');
    Route::post('/edit/accept',[Reciever\UserController::class, 'accept'])->name('factory.reciever.post.accept');
    Route::post('/edit/disagree',[Reciever\UserController::class, 'disagree'])->name('factory.reciever.post.disagree');

    //Current
    Route::get('/current',[Reciever\UserController::class, 'current'])->name('factory.reciever.current');
    Route::get('/current/{id?}',[Reciever\UserController::class, 'currentInfo'])->name('factory.reciever.info');

    //disagree
    Route::get('/disagreement',[Reciever\UserController::class, 'disagreementShow'])->name('factory.reciever.disagree');
    Route::get('/canceled',[Reciever\UserController::class, 'canceled'])->name('factory.reciever.canceled');

    //USer
    Route::get('/user',[Reciever\WorkerController::class, 'show'])->name('factory.reciever.user');
    Route::post('/user/add',[Reciever\WorkerController::class, 'add'])->name('factory.reciever.post.add.user');
    Route::post('/user/edit',[Reciever\WorkerController::class, 'edit'])->name('factory.reciever.post.edit.user');
    
    //Profile
    Route::get('/account',[Reciever\ProfileController::class, 'show'])->name('factory.reciever.profile');
    Route::post('/changepassword',[Reciever\ProfileController::class, 'password'])->name('factory.reciever.post.password');
});

Route::middleware(['auth','role:chief_worker'])->prefix('chief')->group(function () {

    Route::get('/',[ChiefWorker\UserController::class, 'show'])->name('chief.panel');
    Route::get('/edit/{id?}',[ChiefWorker\UserController::class, 'viewEdit'])->name('chief.edit');
    Route::post('/edit/accept',[ChiefWorker\UserController::class, 'accept'])->name('chief.post.accept');
    Route::post('/edit/disagree',[ChiefWorker\UserController::class, 'disagree'])->name('chief.post.disagree');

    //Current
    Route::get('/current',[ChiefWorker\UserController::class, 'current'])->name('chief.current');
    Route::get('/current/{id?}',[ChiefWorker\UserController::class, 'currentInfo'])->name('chief.info');

    Route::get('/list',[ChiefWorker\UserController::class, 'listCurrent'])->name('chief.current.list');
    Route::post('/current/accept',[ChiefWorker\UserController::class, 'currentAccept'])->name('chief.post.current.accept');

    Route::post('/workeraccept',[ChiefWorker\UserController::class, 'workerAccept'])->name('chief.post.worker.accept');
    

    // User
    Route::get('/user',[ChiefWorker\WorkerController::class, 'show'])->name('chief.user');
    Route::post('/user/add',[ChiefWorker\WorkerController::class, 'add'])->name('chief.post.add.user');
    Route::post('/user/edit',[ChiefWorker\WorkerController::class, 'edit'])->name('chief.post.edit.user');
    Route::post('/user/delete',[ChiefWorker\WorkerController::class, 'delete'])->name('chief.post.delete.user');

    //Profile
    Route::get('/account',[ChiefWorker\ProfileController::class, 'show'])->name('chief.profile');
    Route::post('/changepassword',[ChiefWorker\ProfileController::class, 'password'])->name('chief.post.password');

    Route::get('/status',[ChiefWorker\ProfileController::class, 'status'])->name('chief.status');

    //old requests
    Route::get('/archive',[ChiefWorker\UserController::class, 'archive'])->name('chief.archive');

});

Route::middleware(['auth','role:worker'])->prefix('worker')->group(function () {
    Route::get('/',[Worker\UserController::class, 'show'])->name('worker.panel');
    Route::get('/edit/{id?}',[Worker\UserController::class, 'viewEdit'])->name('worker.edit');
    Route::post('/edit/accept',[Worker\UserController::class, 'accept'])->name('worker.post.accept');

    //Current
    Route::get('/current',[Worker\UserController::class, 'current'])->name('worker.current');

    //Profile
    Route::get('/account',[Worker\ProfileController::class, 'show'])->name('worker.profile');
    Route::post('/changepassword',[Worker\ProfileController::class, 'password'])->name('worker.post.password');

    Route::get('/status',[Worker\ProfileController::class, 'status'])->name('worker.status');

});

Route::middleware(['auth','role:dryer'])->prefix('dryer')->group(function () {
    Route::get('/',[Dryer\UserController::class, 'show'])->name('dryer.panel');
    Route::get('/edit/{id?}',[Dryer\UserController::class, 'viewEdit'])->name('dryer.edit');
    Route::post('/edit/accept',[Dryer\UserController::class, 'accept'])->name('dryer.post.accept');
    Route::post('/edit/disagree',[Dryer\UserController::class, 'disagree'])->name('dryer.post.disagree');

    //Current
    Route::get('/current',[Dryer\UserController::class, 'current'])->name('dryer.current');
    Route::post('/current/accept',[Dryer\UserController::class, 'currentAccept'])->name('dryer.post.current.accept');
    
    Route::get('/list',[Dryer\UserController::class, 'oldlist'])->name('dryer.list');

    //Profile
    Route::get('/account',[Dryer\ProfileController::class, 'show'])->name('dryer.profile');
    Route::post('/changepassword',[Dryer\ProfileController::class, 'password'])->name('dryer.post.password');

});

Route::middleware(['auth','role:packager'])->prefix('pack')->group(function () {
    Route::get('/',[Pack\UserController::class, 'show'])->name('pack.panel');
    Route::get('/edit/{id?}',[Pack\UserController::class, 'viewEdit'])->name('pack.edit');
    Route::post('/edit/accept',[Pack\UserController::class, 'accept'])->name('pack.post.accept');
    

    //Current
    Route::get('/current',[Pack\UserController::class, 'current'])->name('pack.current');
    Route::post('/current/accept',[Pack\UserController::class, 'currentAccept'])->name('pack.post.current.accept');
    
    Route::get('/list',[Pack\UserController::class, 'oldlist'])->name('pack.list');

    //Profile
    Route::get('/account',[Pack\ProfileController::class, 'show'])->name('pack.profile');
    Route::post('/changepassword',[Pack\ProfileController::class, 'password'])->name('pack.post.password');

});

Route::middleware(['auth','role:distributor'])->prefix('distributor')->group(function () {
    Route::get('/',[Distributor\UserController::class, 'show'])->name('distributor.panel');
    Route::get('/view/{id?}',[Distributor\UserController::class, 'viewEdit'])->name('distributor.view');
    Route::post('/accept',[Distributor\UserController::class, 'accept'])->name('distributor.post.accept');
    Route::get('/account',[Distributor\ProfileController::class, 'show'])->name('distributor.profile');
    Route::post('/changepassword',[Distributor\ProfileController::class, 'password'])->name('distributor.post.password');
});