<?php

namespace App\Http\Controllers\Pack;

use App\Http\Controllers\Controller;
use App\Models\AppRequest;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Worker;
use App\Models\WorkReq;
use Illuminate\Support\Facades\Auth;
use Morilog\Jalali\Jalalian;

class UserController extends Controller
{
    public function show()
    {
        $perPage = 25;
        $page = request()->input('page', 1);

        $query = AppRequest::where('requests.step', 11)
            ->join('users', 'requests.user_id', '=', 'users.id')
            ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
            ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name');

        $RequestInfo = $query->orderBy('id', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);

        return view('Packaging.index', compact('RequestInfo'));
    }

    public function viewEdit($id = null)
    {
        if ($id != null && (int) $id > 0) {
            $RequestInfo = AppRequest::where('requests.id', $id)
                ->join('users', 'requests.user_id', '=', 'users.id')
                ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
                ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name')
                ->first();

            return view('Packaging.edit', compact(['RequestInfo']));
        }

        return redirect()->route('pack.panel');
    }

    public function accept(Request $request)
    {
        $reqid = $request->requestId;
        $safrane = $request->safrane;
        $RequestInfo = AppRequest::where('id', $reqid)->first();

        $RequestInfo->step = 12;

        $stepInfo = $RequestInfo->step_info;

        if (!is_array($stepInfo)) {
            $stepInfo = [];
        }

        $stepInfo[] = [
            'action' => 'واحد بسته بندی ' . Auth::user()->first_name . ' ' . Auth::user()->last_name . ' زعفران را تحویل گرفت.',
            'user_id' => Auth::id(),
            'date' => Jalalian::now()->format('Y/m/d H:i:s')
        ];

        $RequestInfo->step_info =  $stepInfo;

        $oldweight = $RequestInfo->weight;

        $oldweight['pack'] = $safrane;

        $RequestInfo->weight = $oldweight;

        $RequestInfo->save();

        return redirect()->route('pack.panel');
    }

    public function current()
    {
        $perPage = 25;
        $page = request()->input('page', 1);
        $query = AppRequest::where('requests.step', 12)
            ->join('users', 'requests.user_id', '=', 'users.id')
            ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
            ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name');

        $RequestInfo = $query->orderBy('id', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);

        return view('Packaging.index', compact('RequestInfo'));
    }

    public function currentAccept(Request $request)
    {
        $safrane = $request->safrane;
        $reqid = $request->requestId;
        $RequestInfo = AppRequest::where('id', $reqid)->first();

        $RequestInfo->step = 13;

        $stepInfo = $RequestInfo->step_info;

        if (!is_array($stepInfo)) {
            $stepInfo = [];
        }

        $stepInfo[] = [
            'action' => 'واحد بسته بندی ' . Auth::user()->first_name . ' ' . Auth::user()->last_name . ' کار را تمام کرد.',
            'user_id' => Auth::id(),
            'date' => Jalalian::now()->format('Y/m/d H:i:s')
        ];

        $RequestInfo->step_info =  $stepInfo;

        $RequestInfo->save();

        return redirect()->route('pack.panel');
    }

    public function oldlist()
    {
        $perPage = 25;
        $page = request()->input('page', 1);
        $query = AppRequest::where('requests.step', '>' , 12)
            ->join('users', 'requests.user_id', '=', 'users.id')
            ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
            ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name');

        $RequestInfo = $query->orderBy('id', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);

        return view('Packaging.index', compact('RequestInfo'));
    }
}
