<?php

namespace App\Http\Requests;

use App\Rules\IranianPhone;
use App\Rules\Nationalcode;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class FRUserAddRequest extends FormRequest
{

    public function authorize()
    {
        if(Auth::check() && Auth::user()->role == 'factory_receiver')
        {
            return true;
        }

        return false;
    }


    public function rules()
    {
        
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'melli_code' => ['required', 'unique:users,melli_code'],
            'phone' => ['required', new IranianPhone, 'unique:users,phone'],
            'role' => [ 'required', Rule::in(['chief_worker', 'worker']) ] 
        ];
    }

    public function messages()
    {
        return [
            'mell_code.required' => 'کد ملی وارد نشده است.',
            'phone.required' => 'شماره موبایل وارد نشده است',
            'mell_code.unique' => 'کدملی قبلا ثبت شده است',
            'phone.unique' => 'شماره موبایل قبلا ثبت شده است',
            'role.required' => 'نقش کاربر باید مشخص شود.',
            'role.in' => 'نقش کاربر فقط می‌تواند سرتیم یا کارگر باشد.'
        ];
    }
}
