<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Rules\Nationalcode;

class MelliCodeRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }


    public function rules()
    {
        return [
            'melli_code' => ['required', new Nationalcode],
            'requestId' => 'required'
        ];
    }

    public function messages()
    {
        return [
            'mell_code.required' => 'کد ملی وارد نشده است.',
            'requestId.required' => 'درخواست مشخص نشده است.'
        ];
    }
}
