$(document).ready(function () {
    jalaliDatepicker.startWatch({
        minDate: "attr",
        maxDate: "attr",
        minTime: "attr",
        maxTime: "attr",
        time: true,
        date: true,
        hasSecond: true,
        hideAfterChange: false,
        autoHide: true,
        showTodayBtn: true,
        showEmptyBtn: true,
        topSpace: 10,
        bottomSpace: 30,
        overflowSpace: -10,
        dayRendering(opt, input) {
            return {
                isHollyDay: opt.day == 1,
            };
        },
    });
});

document.addEventListener("DOMContentLoaded", function () {
    const tableBody = document.getElementById("FormBodyTable");
    let rowCounter = document.querySelectorAll("#FormBodyTable tr").length;

    let workerPriceInputs = document.querySelectorAll(
        'input[name="workerprice1[]"]'
    );

    initializeSelect2();

    tableBody.addEventListener("click", function (e) {
        if (e.target.classList.contains("addrow")) {
            const currentRow = e.target.closest("tr");

            const newRow = currentRow.cloneNode(true);

            newRow
                .querySelectorAll(".select2-container")
                .forEach((container) => {
                    container.remove();
                });

            newRow
                .querySelectorAll('select[name="worker[]"]')
                .forEach((select) => {
                    select.classList.remove("select2-hidden-accessible");
                    select.removeAttribute("data-select2-id");
                    select.removeAttribute("tabindex");
                    select.removeAttribute("aria-hidden");
                });

            rowCounter++;

            const addIcon = newRow.querySelector(".fa-circle-plus");
            if (addIcon) {
                addIcon.classList.remove("fa-circle-plus", "addrow");
                addIcon.classList.add("fa-circle-minus", "remove-row");
                addIcon.style.color = "#dc3545";
            }

            const selectElement = newRow.querySelector(
                'select[name="worker[]"]'
            );
            if (selectElement) {
                selectElement.id = "worker_" + rowCounter;

                if (selectElement.hasAttribute("data-select2-id")) {
                    $(selectElement).select2("destroy");
                }
            }

            newRow.querySelectorAll("input").forEach((input) => {
                input.value = "";

                if (input.hasAttribute("data-jdp")) {
                    if (input._jdp) {
                        input._jdp.destroy();
                    }
                }
            });

            newRow
                .querySelectorAll('input[name="workerprice1[]"]')
                .forEach((input) => {
                    input.value = addPriceSeparator(workerPrice);
                });

            newRow
                .querySelectorAll('input[name="workerprice[]"]')
                .forEach((input) => {
                    input.value = workerPrice;
                });

            newRow.querySelectorAll("select").forEach((select) => {
                select.selectedIndex = 0;
            });

            currentRow.after(newRow);

            initializeSelect2();

            if (typeof jDatepicker !== "undefined") {
                jDatepicker(newRow.querySelector("input[data-jdp]"));
            }

            workerPriceInputs = document.querySelectorAll(
                'input[name="workerprice1[]"]'
            );

            workerPriceInputs.forEach((input) => {
                input.addEventListener("input", function () {
                    updateChiefPriceWorker(this);
                });
            });
        }

        if (e.target.classList.contains("remove-row")) {
            if (tableBody.querySelectorAll("tr").length <= 1) {
                alert("حداقل باید یک ردیف وجود داشته باشد!");
                return;
            }

            const row = e.target.closest("tr");
            const selectElement = row.querySelector('select[name="worker[]"]');
            if (
                selectElement &&
                selectElement.hasAttribute("data-select2-id")
            ) {
                $(selectElement).select2("destroy");
            }

            row.remove();
        }
    });

    function initializeSelect2() {
        $('select[name="chiefWorker[]"]').each(function () {
            if (!$(this).hasClass("select2-hidden-accessible")) {
                console.log("#" + this.id);
                $("#" + this.id).select2({
                    theme: "bootstrap-5",
                    placeholder: "انتخاب کارگر",
                    allowClear: false,
                    language: "fa",
                    width: "100%",
                });
            }
        });
    }

    const submitBtn = document.getElementById("SubmitFormBtn");
    submitBtn.addEventListener("click", function (e) {
        e.preventDefault();
        const editForm = document.getElementById("EditForm");
        const oldWeight = Number(document.getElementById("oldweight").value);
        let newWeight = 0;
        document.querySelectorAll('input[name="weight[]"]').forEach((input) => {
            if (input.value != null && input.value != "") {
                newWeight = newWeight + Number(input.value);
            }
        });

        if (oldWeight > newWeight) {
            Swal.fire({
                title: "اخطار زربرج",
                text: "همه وزن ها توزیع نشده است.",
                icon: "error",
                confirmButtonText: "متوجه شدم",
            });
        } else if (oldWeight < newWeight) {
            Swal.fire({
                title: "اخطار زربرج",
                text: "وزن توزیع شده بیشتر از وزن اعلامی می باشد.",
                icon: "error",
                confirmButtonText: "متوجه شدم",
            });
        } else if (oldWeight == newWeight) {
            editForm.submit();
        }
    });

    workerPriceInputs.forEach((input) => {
        input.addEventListener("input", function () {
            updateChiefPriceWorker(this);
        });
    });

    function updateChiefPriceWorker(inputElement) {
        const inputs = document.querySelectorAll(
            'input[name="workerprice1[]"]'
        );
        const index = Array.from(inputs).indexOf(inputElement);

        const hiddenInputs = document.querySelectorAll(
            'input[name="workerprice[]"]'
        );

        if (hiddenInputs[index]) {
            hiddenInputs[index].value = removePriceSeparator(
                inputElement.value
            );
            inputElement.value = addPriceSeparator(inputElement.value);
        }
    }

    function addPriceSeparator(number) {
        number = removePriceSeparator(number);

        if (parseInt(number) >= 0) {
            return parseInt(number).toLocaleString();
        }
        return 0;
    }

    function removePriceSeparator(formattedNumber) {
        return formattedNumber.toString().replace(/,/g, "");
    }
});
