document.addEventListener("DOMContentLoaded", function () {
    const AcceptButton = document.getElementById("AcceptAndConitinueBtn");
    AcceptButton.addEventListener("click", function () {
        const ContractDiv = document.getElementById("editor");
        const ContractInput = document.getElementById("contract");
        const editForm = document.getElementById("editForm");
        ContractInput.value = ContractDiv.innerHTML;
        editForm.submit();
    });

    function addPriceSeparator(number) {
        number = removePriceSeparator(number);

        if(parseInt(number) >= 0)
        {
            return parseInt(number).toLocaleString();
        }
        return 0;
    }

    function removePriceSeparator(formattedNumber) {
        return formattedNumber.toString().replace(/,/g, "");
    }

    function updatePrice() {
        const priceperunit = document.getElementById("priceperunit");
        const weightInput = document.getElementById("weight");
        const pricetext = document.getElementById("pricetext");

        const oldprice = removePriceSeparator(priceperunit.value);

        const price = parseFloat(oldprice) || 0;
        const weight = parseFloat(weightInput.value) || 0;

        const newprice = price * weight;

        if (newprice > 0) {
            pricetext.textContent = `قیمت کل ${newprice.toLocaleString()} تومان`;
            document.getElementById("price").value = newprice;
        } else {
            pricetext.textContent = "قیمت را وارد کنید";
            document.getElementById("price").value = "";
        }

        document.getElementById("priceperunit").value = addPriceSeparator(oldprice);
    }

    function updatePricetrans() {
        const priceperunit = document.getElementById("transportprice");
        const weightInput = document.getElementById("weight");
        const pricetext = document.getElementById("priceTranstext");

        const oldprice = removePriceSeparator(priceperunit.value);

        const price = parseFloat(oldprice) || 0;
        const weight = parseFloat(weightInput.value) || 0;

        const newprice = price * weight;

        if (newprice > 0) {
            pricetext.textContent = `قیمت کل ${newprice.toLocaleString()} تومان`;
            document.getElementById("priceTrans").value = newprice;
        } else {
            pricetext.textContent = "قیمت را وارد کنید";
            document.getElementById("priceTrans").value = "";
        }

        document.getElementById("transportprice").value = addPriceSeparator(oldprice);
    }

    document
        .getElementById("priceperunit")
        .addEventListener("input", updatePrice);

    document
        .getElementById("transportprice")
        .addEventListener("input", updatePricetrans);
    document.getElementById("weight").addEventListener("input", updatePrice);


    document.getElementById('weight').addEventListener('input',function() {
        let weight = document.getElementById('weight').value;
        let Unit = document.getElementById('weightUnit').value;
        if(document.getElementById('weightContract'))
        {
            document.getElementById('weightContract').textContent = weight + ' ' + Unit;
        }
    });

    document.getElementById('weightUnit').addEventListener('input',function() {
        let weight = document.getElementById('weight').value;
        let Unit = document.getElementById('weightUnit').value;
        if(document.getElementById('weightContract'))
        {
            document.getElementById('weightContract').textContent = weight + ' ' + Unit;
        }
    });
});
